-- initialize the "URL not-found" handling template
CREATE TEMPORARY TABLE `InvalidURLTemplates`
    SELECT IdPublication, IssueTplId
    FROM Issues AS I1 WHERE Number = (
        SELECT MAX(Number) FROM Issues AS I2
        WHERE I1.IdPublication = I2.IdPublication AND IssueTplId > 0)
    GROUP BY IdPublication;
UPDATE Publications, InvalidURLTemplates SET url_error_tpl_id = IssueTplId
WHERE Publications.Id = InvalidURLTemplates.IdPublication;
DROP TEMPORARY TABLE `InvalidURLTemplates`;


-- set published articles from unpublished issues to "publish with issue" stage
UPDATE Articles, Issues SET Articles.Published = 'M'
WHERE Articles.NrIssue = Issues.Number
    AND Articles.IdLanguage = Issues.IdLanguage
    AND Articles.Published = 'Y'
    AND Issues.Published = 'N'; 


-- add new system preferences for tinymce editor image resizing and zooming
INSERT INTO `SystemPreferences` (`varname`, `value`) VALUES ('EditorImageResizeWidth', '');
INSERT INTO `SystemPreferences` (`varname`, `value`) VALUES ('EditorImageResizeHeight', '');
INSERT INTO `SystemPreferences` (`varname`, `value`) VALUES ('EditorImageZoom', 'N');


-- add disabled time zone by default
INSERT INTO `SystemPreferences` (`varname`, `value`) VALUES ('TimeZone', NULL);

-- add external cron handler
INSERT INTO `SystemPreferences` (`varname`, `value`) VALUES ('ExternalCronManagement', 'Y');


-- Initialize the topics order field
SET @i:=0;
CREATE TEMPORARY TABLE `TopicsTmp` SELECT DISTINCT `Id`, `LanguageId`, `Name`, `TopicOrder` FROM `Topics`;
DELETE FROM `TopicsTmp` WHERE 
    Id IN (SELECT Id FROM `Topics` GROUP BY Id HAVING COUNT(LanguageId) > 1) 
    AND LanguageId NOT IN (SELECT LanguageId FROM `Topics` GROUP BY Id HAVING COUNT(LanguageId) > 1);
UPDATE `TopicsTmp` SET `TopicOrder`= @i:=@i+1 ORDER BY Id ASC, LanguageId ASC, Name ASC;
UPDATE `Topics` SET `TopicOrder`= (SELECT `TopicsTmp`.`TopicOrder` FROM `TopicsTmp` WHERE `TopicsTmp`.Id = `Topics`.Id);
DROP TEMPORARY TABLE `TopicsTmp`;


-- Fix the article order issues generated by bad coding
CREATE TEMPORARY TABLE ArticleOrderDup
SELECT NrSection, ArticleOrder, COUNT(ArticleOrder) AS dup FROM Articles 
GROUP BY NrSection, ArticleOrder, IdLanguage
HAVING dup > 1 
ORDER BY ArticleOrder;

UPDATE Articles, ArticleOrderDup 
SET Articles.ArticleOrder = Articles.ArticleOrder + ArticleOrderDup.dup - 1
WHERE Articles.NrSection = ArticleOrderDup.NrSection
    AND Articles.ArticleOrder > ArticleOrderDup.ArticleOrder;

DROP TEMPORARY TABLE ArticleOrderDup;

CREATE TEMPORARY TABLE ArticleOrderDup
SELECT NrSection, ArticleOrder, COUNT(ArticleOrder) AS dup FROM Articles 
GROUP BY NrSection, ArticleOrder, IdLanguage
HAVING dup > 1 
ORDER BY ArticleOrder;

SET @i := 0;
CREATE TEMPORARY TABLE DupOrderArticles
SELECT Articles.Number, Articles.ArticleOrder + (@i := @i + 1) - 1 AS ArticleOrder,
    Articles.NrSection, ArticleOrderDup.dup, 
    (@i < ArticleOrderDup.dup OR (@i := 0)) AS reset_index
FROM Articles, ArticleOrderDup
WHERE Articles.NrSection = ArticleOrderDup.NrSection
    AND Articles.ArticleOrder = ArticleOrderDup.ArticleOrder;

UPDATE Articles, DupOrderArticles
SET Articles.ArticleOrder = DupOrderArticles.ArticleOrder
WHERE Articles.Number = DupOrderArticles.Number
    AND Articles.NrSection = DupOrderArticles.NrSection;

DROP TEMPORARY TABLE ArticleOrderDup;
DROP TEMPORARY TABLE DupOrderArticles;


-- add additional group rights
system php ./update_rights.php
